package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.udc.UdcName;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;

/**
 * 客户经营
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
@ExcelIgnoreUnannotated
public class CrmCustomerOperationExcelExport {

    /**
     * 客户表主键
     */
    private Long customerId;

    /**
     * 客户经营编号
     */
    private String custNo;

    /**
     * 类型 udc
     */
    private String custType;
    @UdcName(udcName = "crm:cust_oper:type", codePropName = "custType")
    @ExcelProperty(index = 1, value = "类型")
    private String custTypeDesc;

    /**
     * 第三方公司主键：天眼查id or 启信宝id
     */
    private String threeId;

    /**
     * 第三方公司类型：天眼查:TYC or 启信宝:QXB
     */
    private String threeType;


    /**
     * 名称
     */
    @ExcelProperty(index = 0, value = "客户名称")
    private String custName;

    /**
     * 公司性质 udc[crm:company_nature]
     */
    private String custNature;
    @UdcName(udcName = "crm:company_nature", codePropName = "custNature")
    private String custNatureDesc;

    /**
     * 行业 udc[crm:leads_customer_industry]
     */
    private String custIndustry;
    @UdcName(udcName = "crm:leads_customer_industry", codePropName = "custIndustry")
    @ExcelProperty(index = 9, value = "行业")
    private String custIndustryDesc;

    /**
     * 母公司主键
     */
    private Long parentId;

    /**
     * 母公司名称
     */
    @ExcelProperty(index = 7, value = "母公司")
    private String parentCompany;

    /**
     * 网址
     */
    @ExcelProperty(index = 3, value = "网址")
    private String website;

    /**
     * 座机
     */
    @ExcelProperty(index = 4, value = "联系方式")
    private String landline;

    /**
     * 邮箱
     */
    @ExcelProperty(index = 2, value = "邮箱")
    private String email;

    @ExcelProperty(index = 5, value = "省/市/区")
    private String addressStr;

    public String getAddressStr() {
        String result = "";
        if (StringUtils.hasText(provinceName)) {
            result += provinceName + "/";
        }
        if (StringUtils.hasText(cityName)) {
            result += cityName + "/";
        }
        if (StringUtils.hasText(districtName)) {
            result += districtName;
        }
        return result;
    }

    /**
     * 省
     */
    private String province;

    /**
     * 省名字
     */
    private String provinceName;

    /**
     * 城市
     */
    private String city;

    /**
     * 城市名字
     */
    private String cityName;

    /**
     * 区
     */
    private String district;

    /**
     * 地区名称
     */
    private String districtName;

    /**
     * 地址
     */
    @ExcelProperty(index = 6, value = "地址")
    private String custAddress;

    /**
     * 客户级别 udc[crm:cust_oper:cust_grade]
     */
    private String custGrade;
    @UdcName(udcName = "crm:cust_oper:cust_grade", codePropName = "custGrade")
    @ExcelProperty(index = 8, value = "客户级别")
    private String custGradeDesc;

    /**
     * 销售规模
     */
    private BigDecimal saleScale;
    @ExcelProperty(index = 13, value = "销售规模（亿元）")
    private String saleScaleStr;

    public String getSaleScaleStr() {
        return saleScale != null ? saleScale.toString() : "";
    }

    /**
     * 行业地位 udc[crm:cust_oper:cust_industry]
     */
    private String industryStand;
    @UdcName(udcName = "crm:cust_oper:cust_industry", codePropName = "industryStand")
    @ExcelProperty(index = 14, value = "行业地位")
    private String industryStandDesc;

    /**
     * 数字化投入力度 udc[crm:cust_oper:digital]
     */
    private String digitalInvestment;
    @UdcName(udcName = "crm:cust_oper:digital", codePropName = "digitalInvestment")
    @ExcelProperty(index = 15, value = "数字化投入力度")
    private String digitalInvestmentDesc;

    /**
     * 与公司紧密度 udc[crm:cust_oper:tightness]
     */
    private String companyTightness;
    @UdcName(udcName = "crm:cust_oper:tightness", codePropName = "companyTightness")
    @ExcelProperty(index = 16, value = "与公司紧密度")
    private String companyTightnessDesc;

    /**
     * 历史合作产出（万元）
     */
    private BigDecimal historyCooOutput;
    @ExcelProperty(index = 17, value = "历史合作产出（万元）")
    private String historyCooOutputStr;

    public String getHistoryCooOutputStr() {
        return historyCooOutput != null ? historyCooOutput.toString() : "";
    }

    /**
     * 销售经营部门
     */
    private Long saleOperBu;
    @UdcName(udcName = "BU", codePropName = "saleOperBu")
    @ExcelProperty(index = 18, value = "销售经营部门")
    private String saleOperBuName;

    /**
     * 销售经营部负责人
     */
    private Long saleOperManagerId;

    /**
     * 销售经营部负责人
     */
    @UdcName(udcName = "USER", codePropName = "saleOperManagerId")
    @ExcelProperty(index = 19, value = "销售经营部负责人")
    private String saleOperManagerName;

    /**
     * 客户经营部门
     */
    private Long custOperBu;
    @UdcName(udcName = "BU", codePropName = "custOperBu")
    @ExcelProperty(index = 20, value = "客户经营部门")
    private String custOperBuName;

    /**
     * 客户经营部负责人
     */
    private Long custOperManagerId;

    /**
     * 客户经营部负责人
     */
    @UdcName(udcName = "USER", codePropName = "custOperManagerId")
    @ExcelProperty(index = 21, value = "客户经营部负责人")
    private String custOperManagerName;

    /**
     * 经营策略 udc[crm:cust_oper:strategy]
     */
    private String businessStrategy;
    @UdcName(udcName = "crm:cust_oper:strategy", codePropName = "businessStrategy")
    @ExcelProperty(index = 33, value = "经营策略")
    private String businessStrategyDesc;

    /**
     * 主营业务 udc[crm:cust_oper:main_business]
     */
    private String mainBusiness;
    @UdcName(udcName = "crm:cust_oper:main_business", codePropName = "mainBusiness")
    @ExcelProperty(index = 22, value = "主营业务")
    private String mainBusinessDesc;

    /**
     * 销售覆盖
     */
    private String saleCover;

    @ExcelProperty(index = 23, value = "销售覆盖")
    @UdcName(udcName = "crm:customer_region", codePropName = "saleCover")
    private String saleCoverDesc;

    /**
     * 合作形式 udc[crm:cust_oper:coop_type]
     */
    private String coopType;
    @ExcelProperty(index = 24, value = "合作形式")
    @UdcName(udcName = "crm:cust_oper:coop_type", codePropName = "coopType")
    private String coopTypeDesc;

    /**
     * 合作等级
     */
    @ExcelProperty(index = 25, value = "合作等级")
    private String coopLevel;

    /**
     * 渠道经营部门
     */
    private Long channelBu;
    @UdcName(udcName = "BU", codePropName = "channelBu")
    @ExcelProperty(index = 26, value = "渠道经营部门")
    private String channelBuName;

    /**
     * 渠道经营负责人
     */
    private Long channelUserId;
    @UdcName(udcName = "USER", codePropName = "channelUserId")
    @ExcelProperty(index = 27, value = "渠道经营负责人")
    private String channelUserName;

    /**
     * 产品负责人
     */
    private Long productUserId;
    @UdcName(udcName = "USER", codePropName = "productUserId")
    @ExcelProperty(index = 32, value = "产品负责人")
    private String productUserName;

    /**
     * 生态伙伴业务简述
     */
    @ExcelProperty(index = 12, value = "生态伙伴业务简述")
    private String ecoDescription;

    /**
     * 客户企业 业务简述
     */
    @ExcelProperty(index = 10, value = "客户企业业务简述")
    private String custDescription;

    /**
     * 组织及协会简述
     */
    @ExcelProperty(index = 11, value = "组织及协会简述")
    private String orgAssDescription;

    /**
     * 服务负责人
     */
    private Long serviceUserId;

    /**
     * 服务负责人
     */
    @UdcName(udcName = "USER", codePropName = "serviceUserId")
    @ExcelProperty(index = 28, value = "服务负责人")
    private String serviceUserName;

    /**
     * 商务负责人
     */
    private Long businessUserId;

    /**
     * 商务负责人
     */
    @UdcName(udcName = "USER", codePropName = "businessUserId")
    @ExcelProperty(index = 29, value = "商务负责人")
    private String businessUserName;

    /**
     * 关怀负责人
     */
    private Long careUserId;

    /**
     * 关怀负责人
     */
    @UdcName(udcName = "USER", codePropName = "careUserId")
    @ExcelProperty(index = 30, value = "关怀负责人")
    private String careUserName;

    /**
     * 运维售后负责人
     */
    private Long operationUserId;

    /**
     * 运维售后负责人
     */
    @UdcName(udcName = "USER", codePropName = "operationUserId")
    @ExcelProperty(index = 31, value = "运维售后负责人")
    private String operationUserName;

    /**
     * 拓展1  企业logo 来源zi
     */
    private String ext1;

    /**
     * 拓展2
     */
    private String ext2;

    /**
     * 拓展3
     */
    private String ext3;

    /**
     * 拓展4
     */
    private String ext4;

    /**
     * 拓展5
     */
    private String ext5;

    /**
     * 导入警告
     */
    private String importWarn;

    /**
     * 导入错误
     */
    private String imoprtError;

    private Long createUserId;

    private String remark;

    private Integer deleteFlag;

}
