package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

@Data
@ExcelIgnoreUnannotated
public class CrmGiftInfoExcelExport {

    /**
     * 礼品单编号
     */
    @ApiModelProperty("礼品单编号")
    @ExcelProperty(index = 0, value = "礼品单编号")
    private String giftNo;
    /** 申请人 */
    @ApiModelProperty("申请用户ID")
    private Long applyUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    @ExcelProperty(index = 1, value = "申请人")
    private String applyUser;

    /** 申请BU */
    @ApiModelProperty("申请BU")
    private Long applyUserBuId;
    @UdcName(udcName = "BU", codePropName = "applyUserBuId")
    @ApiModelProperty("申请人BaseBU")
    @ExcelProperty(index = 2, value = "申请人BaseBU")
    private String applyBuName;

    /** 申请状态 */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    @ExcelProperty(index = 3, value = "审批状态")
    private String applyStatusName;

    /** 礼品类型 */
    @ApiModelProperty("礼品类型")
    @ExcelProperty(index = 4, value = "礼品类型")
    private String giftTypeName;

    /** 申请日期 */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    @ExcelProperty(index = 5, value = "申请时间")
    private String applyDateString;

    /** 客户方 */
    @ApiModelProperty("客户方")
    private Long customerId;
    /** 客户名称 */
    @ApiModelProperty("客户方")
    @ExcelProperty(index = 6, value = "客户方")
    private String custName;
    private String custAddress;
    @ApiModelProperty("经营人脉主键")
    private Long peopleId;
    /** 经营人脉 */
    @ApiModelProperty("联系人")
    @ExcelProperty(index = 7, value = "联系人")
    private String peopleName;
    /** 客户经营部门 */
    @ApiModelProperty("部门")
    @ExcelProperty(index = 8, value = "部门")
    private String custOperBu;
    /** 岗位情况 */
    @ApiModelProperty("职位")
    @ExcelProperty(index = 9, value = "职位")
    private String jobDetail;
    /** 联系方式 */
    @ApiModelProperty("联系方式")
    @ExcelProperty(index = 10, value = "联系方式")
    private String mobile;

    /** 礼品寄送地址 */
    @ApiModelProperty("礼品寄送地址")
    @ExcelProperty(index = 11, value = "礼品寄送地址")
    private String locationDetail;
    /** 赠送理由 */
    @ApiModelProperty("赠送理由")
    @ExcelProperty(index = 12, value = "赠送理由")
    private String reason;

    /** 礼品名称 */
    @ApiModelProperty("礼品名称")
    @ExcelProperty(index = 13, value = "礼品名称")
    private String giftName;
    /** 申请数量 */
    @ApiModelProperty("申请数量")
    @ExcelProperty(index = 14, value = "申请数量")
    private String giftNumber;

}
