package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreRuleRegainVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author zoey
 * @Description:近海规则表
 * @date 2022/5/17 - 11:34
 */
@Data
public class CrmOffshoreRulePayload extends TwCommonPayload {

    /**
     * 分配领取规则
     */
    private String distributeReceiveRule;

    /**
     * 新线索提醒:1:提醒；0：不提醒
     */
    private Integer newLeadsRemind;

    /**
     * 线索领取上限
     */
    private Integer receiveLeadsLimit;

    /**
     * 线索连续领取天数上限
     */
    private Integer receiveLeadsLimitDays;

    /**
     * 领取线索提醒:1:提醒；0：不提醒
     */
    private Integer receiveLeadsRemind;

    /**
     * 超时未分配提醒时间
     */
    private Long distributeLeadsRemindTime;

    /**
     * 超时未跟进提醒时间
     */
    private Long followLeadsRemindTime;

    /**
     * 查看未领取线索跟进动态:1:是；0：否
     */
    private Integer showFollowBeforeReceive;

    /**
     * 排除字段列表
     */
    private List<CrmOffshoreRuleAttrExcludePayload> offshoreRuleAttrExcludes;

    /**
     * 收回规则列表
     */
    private CrmOffshoreRuleRegainPayload regainRule;

}
