package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * 客户经营-经营计划明细表
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
public class CrmOperationPlanDetailQuery extends TwQueryParam {

    /**
     * 客户经营主键 crm_customer_operation.id
     */
    @Query
    private Long operId;

    @Query(type = Query.Type.IN, propName = "operId")
    private List<Long> operIdList;

    /**
     * 客户经营名称筛选
     */
    private String custName;

    /**
     * 是否是管理员
     */
    private boolean managerFlag = false;

    ///**
    // * 当前登录人
    // */
    //private Long userId;

    /**
     * 主表id 预留字段 暂无用
     */
    @Query
    private Long planId;

    @Query(type = Query.Type.IN)
    private Collection idList;

    /**
     * 计划名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String planName;

    /**
     * 计划内容
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String planContent;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;


    /**
     * 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    /**
     * 优先级 udc[crm:oper_plan:priority]
     */
    @Query
    private String priority;

    /**
     * 执行者
     */
    @Query
    private Long performerId;

    /**
     * 状态 udc[crm:oper_plan:status]
     */
    @Query
    private String status;

    /**
     * 已读标记，0：未读，1：已读
     */
    @Query
    private Integer readFlag;
    /**
     * 人脉数据
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

    /**
     * 客户经营部门
     */
    private Long custOperBu;
    /**
     * 客户经营部门集合
     */
    @Query(type = Query.Type.IN,propName = "custOperBu")
    private List<Long> custOperBuList;

    /**
     * 是否包含客户经营子部门
     */
    private Boolean subCustOperBuFlag;
    /**
     * 客户经营部负责人
     */
    private Long custOperManagerId;

    /**
     * 销售经营部门
     */
    private Long saleOperBu;


    /**
     * 销售经营部门
     */
    @Query(type = Query.Type.IN,propName = "saleOperBu")
    private List<Long> saleOperBuList;

    /**
     * 是否包含销售经营子部门
     */
    private Boolean subSaleOperBuFlag;

    /**
     * 销售经营部负责人
     */
    private Long saleOperManagerId;

    /**
     * 参与者用户id,逗号分隔
     */
    private String memberUserIds;
}
