package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmGiftInfoPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmGiftInfoQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmGiftListQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmGiftInfoVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 礼品单明细
 *
 * @author xxb
 * @date 2023-08-31
 */
public interface CrmGiftInfoService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CrmGiftInfoVO}>
     */
    PagingVO<CrmGiftInfoVO> queryPaging(CrmGiftInfoQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CrmGiftInfoVO}>
     */
    PagingVO<CrmGiftInfoVO> pagingByGiftList(CrmGiftListQuery query);

    /**
     * 列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CrmGiftInfoVO}>
     */
    List<CrmGiftInfoVO> byGiftList(CrmGiftListQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CrmGiftInfoVO}>
     */
    List<CrmGiftInfoVO> queryListDynamic(CrmGiftInfoQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CrmGiftInfoVO}
     */
    CrmGiftInfoVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmGiftInfoVO}
     */
    CrmGiftInfoVO insert(CrmGiftInfoPayload payload);

    /**
     * 批量新增
     * @param crmGiftInfoPayloads
     */
    void batchInsert(List<CrmGiftInfoPayload> crmGiftInfoPayloads);

    /**
     * 批量新增
     * @param crmGiftInfoPayloads
     */
    void batchUpdate(List<CrmGiftInfoPayload> crmGiftInfoPayloads);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CrmGiftInfoVO}
     */
    CrmGiftInfoVO update(CrmGiftInfoPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(CrmGiftInfoPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    void downloadBatch(HttpServletResponse response,CrmGiftListQuery query);

}
