package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanTempPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanTempVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * 客户经营-经营计划模板
 *
 * @author duwh
 * @date 2022/11/17
 */
public interface CrmOperationPlanTempService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmOperationPlanTempVO}
     */
    CrmOperationPlanTempVO insert(CrmOperationPlanTempPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CrmOperationPlanTempVO}
     */
    CrmOperationPlanTempVO update(CrmOperationPlanTempPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    CrmOperationPlanTempVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link CrmOperationPlanTempVO}>
     */
    List<CrmOperationPlanTempVO> queryList(CrmOperationPlanTempQuery query);


    /**
     * 分页列表
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link CrmOperationPlanTempVO}>
     */
    PagingVO<CrmOperationPlanTempVO> paging(CrmOperationPlanTempQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


}
