package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.boot.common.param.BaseViewModel;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @Author carl.wang
 * @Description 市场活动表
 * @Date
 **/

@Data

public class CrmActReportVO extends BaseViewModel {

    /**
     * 汇报人
     */
    private String employeeName;

    /**
     * 活动Id
     */
    private Long actId;
    /**
     * 项目id
     */
    private Long projectId;
    /**
     * 项目名称（活动名称）
     */
    private String projectName;
    /**
     * 项目编号（活动编号）
     */
    private String projectNo;
    /**
     * 单据号
     */
    private String reportNo;
    /**
     * 项目状态
     */
    private String projectStatus;
    /**
     * 项目状态名称
     */
    private String projectStatusName;

    /**
     * 预算投入总人天
     */
    private Integer budPersonNum;
    /**
     * 累计投入总人天
     */
    private Integer personNum;
    /**
     * 预算投入人力费用
     */
    private BigDecimal budPersonMoney;

    /**
     * 累计投入人力费用
     */
    private BigDecimal personMoney;

    /**
     * 预算投入报销费用
     */
    private BigDecimal budClaimMoney;

    /**
     * 累计投入报销费用
     */
    private BigDecimal claimMoney;
    /**
     * 预算投入采购费用
     */
    private BigDecimal budPurchaseMoney;

    /**
     * 累计投入采购费用
     */
    private BigDecimal purchaseMoney;
    /**
     * 预算投入杂项费用
     */
    private BigDecimal budSundryMoney;

    /**
     * 累计投入杂项费用
     */
    private BigDecimal sundryMoney;

    /**
     * 预算投入总额
     */
    private BigDecimal budTotalMoney;

    /**
     * 累计投入总额
     */
    private BigDecimal totalMoney;
    /**
     * 预算产出潜在客户
     */
    private Integer budPotentialCustomer;
    /**
     * 累计产出潜在客户
     */
    private Integer potentialCustomer;
    /**
     * 预算产出线索
     */
    private Integer budLeadNum;
    /**
     * 累计产出线索
     */
    private Integer leadNum;
    /**
     * 预算产出商机
     */
    private Integer budBusOps;
    /**
     * 累计产出商机
     */
    private Integer busOps;
    /**
     * 预算产出收益
     */
    private BigDecimal budPipeline;
    /**
     * 累计产出收益
     */
    private BigDecimal pipeline;
    /**
     * 其他活动说明
     */
    private String reportContent;

    /**
     * 汇报类型
     */
    private Integer reportType;//1：详情汇报，2:结项报告
    /**
     * 项目开始时间（活动开始时间）
     */
    //@DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startTime;
    /**
     * 项目结束时间（活动结束时间）
     */
    //@DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endTime;

    /**
     * 流程实例ID
     */
    private String procInstId;

    /**
     * 流程审批状态
     */
    private ProcInstStatus procInstStatus;
    private String procInstStatusDesc;

    /**
     * 提交时间
     */
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    private LocalDateTime approvedTime;

    /**
     * 报告状态
     */
    private String reportStatus;
    private String reportStatusDesc;

    /**
     * 线索跟进比例
     */
    public BigDecimal leadsFollowPercent;

    /**
     * 线索退回比例
     */
    public BigDecimal leadsBackPercent;
}
