package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 礼品单
 *
 * @author xxb
 * @date 2023-08-31
 */
@Getter
@Setter
public class CrmGiftListVO extends BaseViewModel implements Serializable {
    /**
     * 礼品单编号
     */
    @ApiModelProperty("礼品单编号")
    private String giftNo;

    /**申请用户ID*/
    @ApiModelProperty("申请用户ID")
    private Long applyUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String applyUser;

    /**申请人bu*/
    @ApiModelProperty("申请人bu")
    private Long applyUserBuId;
    @UdcName(udcName = "BU", codePropName = "applyUserBuId")
    @ApiModelProperty("申请BU_Name")
    private String applyUserBuName;

    /**创建人bu*/
    @ApiModelProperty("创建人bu")
    private Long createUserBuId;
    @UdcName(udcName = "BU", codePropName = "createUserBuId")
    @ApiModelProperty("创建人BU_Name")
    private String createUserBuName;

    /**
     * 礼品类型 一级
     */
    @ApiModelProperty("礼品类型 一级")
    private String giftType1;
    /**
     * 礼品类型 二级
     */
    @ApiModelProperty("礼品类型 二级")
    private String giftType2;
    /**
     * 特殊申请用户标志
     */
    @ApiModelProperty("特殊申请用户标志")
    private Integer specialUsersFlag;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /** 申请日期 */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    /** 申请状态 */
    @ApiModelProperty("申请状态")
    private String applyStatus;

    /**
     * 礼品类型 一级
     */
    @ApiModelProperty("礼品类型 一级")
    private String giftTypeName1;
    /**
     * 礼品类型 二级
     */
    @ApiModelProperty("礼品类型 二级")
    private String giftTypeName2;

    @ApiModelProperty("申请状态")
    private String applyStatusName;
}
