package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;


/**
 * 商机review
 *
 * @author zoey
 * @date 2023-11-01
 */
@Getter
@Setter
public class CrmOpportunityReviewVO extends BaseViewModel implements Serializable {
    /**
     * 商机id
     */
    @ApiModelProperty("商机id")
    private Long oppoId;
    /**
     * 风险类型
     */
    @ApiModelProperty("风险类型")
    private String riskType;
    @UdcName(udcName = "crm:oppo:risk_type", codePropName = "riskType")
    private String riskTypeDesc;
    /**
     * 风险点描述
     */
    @ApiModelProperty("风险点描述")
    private String riskDesc;
    /**
     * 应对计划
     */
    @ApiModelProperty("应对计划")
    private String answerPlan;
    /**
     * 计划结束时间
     */
    @ApiModelProperty("计划结束时间")
    private LocalDate planEndTime;
    /**
     * 负责人
     */
    @ApiModelProperty("负责人")
    private Long directorUserId;
    @UdcName(udcName = "USER", codePropName = "directorUserId")
    private String directorUserName;
    /**
     * 已完成、未完成、进行中
     */
    @ApiModelProperty("已完成、未完成、进行中")
    private String finishState;
    /**
     * 已完成、未完成、进行中
     */
    @ApiModelProperty("已完成、未完成、进行中")
    @UdcName(udcName = "crm:oppo:finish_state", codePropName = "finishState")
    private String finishStateDesc;
}
