package com.elitesland.tw.tw5.api.prd.humanresources.payload;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 内部招聘-我的推荐
 *
 * @author zhangxiao
 * @date 2023-12-14
 */
@Getter
@Setter
public class PrdInternalRecommPayload extends TwCommonPayload implements Serializable {
    /**
     * 岗位id
     */
    @ApiModelProperty("岗位id")
    private Long posIt;
    /**
     * 内部推荐编号
     */
    @ApiModelProperty("内部推荐编号")
    private String docNo;
    /**
     * 采用奖励
     */
    @ApiModelProperty("采用奖励")
    private String adoptReward;
    /**
     * 转正日期
     */
    @ApiModelProperty("转正日期")
    private LocalDate formalDate;
    /**
     * 推荐日期
     */
    @ApiModelProperty("推荐日期")
    private LocalDate recommDate;
    /**
     * 是否入职 true 入职 false 不入职
     */
    @ApiModelProperty("是否入职 true 入职 false 不入职")
    private Boolean entryFlag;
    /**
     * 是否转正 true 转正 false 不转正
     */
    @ApiModelProperty("是否转正 true 转正 false 不转正")
    private Boolean formalFlag;
    /**
     * 筛选结果 1、采用 2、不合适 3、简历重复 4、招聘取消
     */
    @ApiModelProperty("筛选结果 1、采用 2、不合适 3、简历重复 4、招聘取消")
    private Integer filterResult;
    /**
     * 招聘负责人
     */
    @ApiModelProperty("招聘负责人")
    private Long managerUserId;
    /**
     * 转正奖励
     */
    @ApiModelProperty("转正奖励")
    private String formalReward;
    /**
     * 被推荐人名称
     */
    @ApiModelProperty("被推荐人名称")
    private String recommUserName;
    /**
     * 推荐人简历
     */
    @ApiModelProperty("推荐人简历")
    private String recommResume;
    /**
     * 推荐人手机号
     */
    @ApiModelProperty("推荐人手机号")
    private String recommPhone;
    /**
     * 推荐状态 1、未提交2、审批中3、已通过4、撤回5、关闭6、已拒绝
     */
    @ApiModelProperty("推荐状态 1、未提交2、审批中3、已通过4、撤回5、关闭6、已拒绝")
    private Integer recommStatus;
    /**
     * 与推荐人关系
     */
    @ApiModelProperty("与推荐人关系")
    private String relate;
    /**
     * 推荐理由
     */
    @ApiModelProperty("推荐理由")
    private String reason;
    /**
     * 被推荐人档案id
     */
    @ApiModelProperty("被推荐人档案id")
    private Long recommUserId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 提交标志
     */
    @ApiModelProperty("提交标志")
    private Boolean submit = false;


    /**
     * 档案id
     */
    @ApiModelProperty("档案id")
    private Long personId;

    /**
     * 档案名称
     */
    @ApiModelProperty("档案名称")
    private String personName;
}
