package com.elitesland.tw.tw5.api.prd.humanresources.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;

@Data
public class EmployeeBlackListQuery extends TwQueryParam {

    @ApiModelProperty("员工id")
    private Long employeeId;

    @ApiModelProperty("员工名称")
    private String personName;

    @ApiModelProperty("personId")
    private Long id;

    @ApiModelProperty("Base地")
    private String extString5;

    @ApiModelProperty("资源类型一")
    private String extString6;

    @ApiModelProperty("资源类型二")
    private String extString9;

    @ApiModelProperty("资源状态")
    private String resourceStatus;

    @ApiModelProperty("审批状态")
    private String apprStatus;

    @ApiModelProperty("所属组织")
    private Long orgId;

    @ApiModelProperty("入职日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate enrollDateStart;

    @ApiModelProperty("入职日期截止")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate enrollDateEnd;

    @ApiModelProperty("合同到期日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate4Start;

    @ApiModelProperty("合同到期日期截止")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate4End;

    @ApiModelProperty("员工编号")
    private String employeeNo;
}
