package com.elitesland.tw.tw5.api.prd.humanresources.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-27
 * @desc : 员工-复合能力
 */

@Data
@ApiModel(description = "员工-复合能力")
public class PrdEmployeCompositeAbilityQuery extends TwQueryParam {


    /**
     * 编号
     */
    @ApiModelProperty("编号")
    private String docNo;

    /**
     * 能力名称
     */
    @ApiModelProperty("能力名称")
    private String abilityName;

    /**
     * 能力id
     */
    @ApiModelProperty("能力id")
    private Long abilityId;

    /**
     * 能力描述
     */
    @ApiModelProperty("能力描述")
    private String abilityDesc;

    /**
     * 主能力
     */
    @ApiModelProperty("主能力")
    private Boolean mainFlag;

    /**
     * 辅能力
     */
    @ApiModelProperty("辅能力")
    private Boolean auxFlag;

    /**
     * 当量系数
     */
    @ApiModelProperty("当量系数")
    private BigDecimal dlRatio;

    /**
     * 获取时间
     */
    @ApiModelProperty("获取时间")
    private LocalDate obtainTime;

    /**
     * 上次认证时间
     */
    @ApiModelProperty("上次认证时间")
    private LocalDate lastCertTime;

    /**
     * 过期时间
     */
    @ApiModelProperty("过期时间")
    private LocalDate expirateTime;

//    /**
//     * 员工id
//     */
//    @ApiModelProperty("员工id")
//    private Long empId;

    /**
     * 员工名称
     */
    @ApiModelProperty("员工名称")
    private String empName;

    /**
     * 员工编号
     */
    @ApiModelProperty("员工编号")
    private String empDocNo;

    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    private Long userId;

    /**
     * 用户ids
     */
    @ApiModelProperty("用户ids")
    private List<Long> userIds;

    /**
     * 复合能力ids
     */
    @ApiModelProperty("复合能力ids")
    private List<Long> abilityIds;

//    /**
//     * 主键ids
//     */
//    @ApiModelProperty("主键ids")
//    private List<Long> ids;
}

