package com.elitesland.tw.tw5.api.prd.humanresources.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
    import java.time.LocalDate;
    import java.time.LocalDateTime;
import java.util.List;

/**
 * 内部招聘-我的推荐
 *
 * @author zhangxiao
 * @date 2023-12-14
 */
@Getter
@Setter
public class PrdInternalRecommQuery extends TwQueryParam implements Serializable{
    /** 主键id 精确 */
    @ApiModelProperty("主键id")
    private Long id;
    /** 岗位id 精确 */
    @ApiModelProperty("岗位id")
    private Long posIt;
    /** 内部推荐编号 精确 */
    @ApiModelProperty("内部推荐编号")
    private String docNo;
    /** 采用奖励 精确 */
    @ApiModelProperty("采用奖励")
    private String adoptReward;
    /** 转正日期 精确 */
    @ApiModelProperty("转正日期")
    private LocalDate formalDate;
    @ApiModelProperty("转正日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate formalDateStart;
    @ApiModelProperty("转正日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate formalDateEnd;
    /** 推荐日期 精确 */
    @ApiModelProperty("推荐日期")
    private LocalDate recommDate;

    /** 推荐开始日期 精确 */
    @ApiModelProperty("推荐开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate recommDateStart;

    /** 推荐结束日期 精确 */
    @ApiModelProperty("推荐结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate recommDateEnd;
    /** 是否入职 true 入职 false 不入职 精确 */
    @ApiModelProperty("是否入职 true 入职 false 不入职")
    private Boolean entryFlag;
    /** 是否转正 true 转正 false 不转正 精确 */
    @ApiModelProperty("是否转正 true 转正 false 不转正")
    private Boolean formalFlag;
    /** 筛选结果 1、采用 2、不合适 3、简历重复 4、招聘取消 精确 */
    @ApiModelProperty("筛选结果 1、采用 2、不合适 3、简历重复 4、招聘取消")
    private Integer filterResult;
    /** 招聘负责人 精确 */
    @ApiModelProperty("招聘负责人")
    private Long managerUserId;
    /** 转转奖励 精确 */
    @ApiModelProperty("转转奖励")
    private String formalReward;
    /** 被推荐人名称 精确 */
    @ApiModelProperty("被推荐人名称")
    private String recommUserName;
    /** 推荐人简历 精确 */
    @ApiModelProperty("推荐人简历")
    private String recommResume;
    /** 推荐人手机号 精确 */
    @ApiModelProperty("推荐人手机号")
    private String recommPhone;
    /** 推荐状态 1、未提交2、审批中3、已通过4、撤回5、关闭6、已拒绝 精确 */
    @ApiModelProperty("推荐状态 1、未提交2、审批中3、已通过4、撤回5、关闭6、已拒绝")
    private Integer recommStatus;
    /** 与推荐人关系 精确 */
    @ApiModelProperty("与推荐人关系")
    private String relate;
    /** 推荐理由 精确 */
    @ApiModelProperty("推荐理由")
    private String reason;
    /** 被推荐人档案id 精确 */
    @ApiModelProperty("被推荐人档案id")
    private Long recommUserId;
    /** 岗位名称 */
    @ApiModelProperty("岗位名称/编号")
    private String internalPostNameOrNo ;
    /** 分类一 */
    @ApiModelProperty("分类一")
    private String jobType1 ;
    /** 分类二 */
    @ApiModelProperty("分类二")
    private String jobType2 ;
    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}
