package com.elitesland.tw.tw5.api.prd.humanresources.query;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import com.elitesland.tw.tw5.api.common.TwQueryParam;



 /**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果
 */
 
@Data
@ApiModel(description = "绩效考核结果")
public class PrdPerformanceExamResultQuery extends TwQueryParam {


    /**
     * 绩效考核id
     */
    @ApiModelProperty("绩效考核id")
    private Long examId;
    
    /**
     * 考核名称
     */
    @ApiModelProperty("考核名称")
    private String examName;
    
    /**
     * 考核开始时间
     */
    @ApiModelProperty("考核开始时间")
    private LocalDate examStartPeriod;
    
    /**
     * 考核结束时间
     */
    @ApiModelProperty("考核结束时间")
    private LocalDate examEndPeriod;
    
    /**
     * 考核员工资源id
     */
    @ApiModelProperty("考核员工资源id")
    private Long empId;
    
    /**
     * 考核员工资源名称
     */
    @ApiModelProperty("考核员工资源名称")
    private String empName;
    
    /**
     * 考核用户id
     */
    @ApiModelProperty("考核用户id")
    private Long userId;
    
    /**
     * 资源类型
     */
    @ApiModelProperty("资源类型")
    private String resType;
    
    /**
     * BaseBu
     */
    @ApiModelProperty("BaseBu")
    private Long baseBuId;
    
    /**
     * 合作方式
     */
    @ApiModelProperty("合作方式")
    private String coopType;
    
    /**
     * 考核说明
     */
    @ApiModelProperty("考核说明")
    private String examDesc;
    
    /**
     * 考核发起人id
     */
    @ApiModelProperty("考核发起人id")
    private Long examCreatUserId;
    
    /**
     * 考核发起人
     */
    @ApiModelProperty("考核发起人")
    private String examCreatUser;
    
    /**
     * 考核发起时间
     */
    @ApiModelProperty("考核发起时间")
    private LocalDateTime examCreatTime;
    
    /**
     * 评分结果
     */
    @ApiModelProperty("评分结果")
    private BigDecimal scoreRes;
    
    /**
     * 等级结果
     */
    @ApiModelProperty("等级结果")
    private String gradeRes;
    
    /**
     * 最终评分说明
     */
    @ApiModelProperty("最终评分说明")
    private String scoreFinalDesc;
    
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String state;
    
    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    private String flowDocNo;

     /**
      * 评分结果
      */
     @ApiModelProperty("评分结果")
     private BigDecimal scoreResStart;

     /**
      * 评分结果
      */
     @ApiModelProperty("评分结果")
     private BigDecimal scoreResEnd;

}

