package com.elitesland.tw.tw5.api.prd.humanresources.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.util.List;

/**
 * 内部招聘管理
 *
 * @author zhangxiao
 * @date 2023-12-13
 */
@Getter
@Setter
public class PrdRecruitPositionQuery extends TwQueryParam implements Serializable{
    /** 主键id 精确 */
    @ApiModelProperty("主键id")
    private Long id;
    /** 招聘编号 精确 */
    @ApiModelProperty("招聘编号")
    private String jobNo;
    /** 招聘名称 精确 */
    @ApiModelProperty("招聘名称")
    private String jobTitle;
    /** 招聘部门 （组织Id） 精确 */
    @ApiModelProperty("招聘部门 （组织Id）")
    private Long baseBuId;
    /** 工作地 精确 */
    @ApiModelProperty("工作地")
    private String baseRegion;
    /** 工作地说明 精确 */
    @ApiModelProperty("工作地说明")
    private String baseRegionDesc;
    /** 招聘人数 精确 */
    @ApiModelProperty("招聘人数")
    private Integer recruitQty;
    /** 工作类型 1、全职2、兼职 精确 */
    @ApiModelProperty("工作类型 1、全职2、兼职")
    private Integer workType;
    /** 服务方式 1、现场 2、远程 3、按需 精确 */
    @ApiModelProperty("服务方式 1、现场 2、远程 3、按需")
    private Integer serviceMode;
    /** 时间要求 1、常规固定 2、灵活安排 精确 */
    @ApiModelProperty("时间要求 1、常规固定 2、灵活安排")
    private Integer timeRequirement;
    /** 岗位简介 精确 */
    @ApiModelProperty("岗位简介")
    private String jobProfile;
    /** 岗位要求 精确 */
    @ApiModelProperty("岗位要求")
    private String jobRequirement;
    /** 是否运行内部推荐(0,1) 精确 */
    @ApiModelProperty("是否运行内部推荐(0,1)")
    private Boolean internalFlag;
    /** 外部资源可见 1、可见(选择) 0、不可见 精确 */
    @ApiModelProperty("外部资源可见 1、可见(选择) 0、不可见")
    private Boolean externalVisible;
    /** 1、招聘中 2、招聘完成 3、招聘取消 精确 */
    @ApiModelProperty("1、招聘中 2、招聘完成 3、招聘取消")
    private Integer recruitmentStatus;
    /** 招聘负责人 精确 */
    @ApiModelProperty("招聘负责人")
    private Long managerUserId;
    /** 招聘分类一 精确 */
    @ApiModelProperty("招聘分类一")
    private String jobType1;
    /** 招聘分类二 精确 */
    @ApiModelProperty("招聘分类二")
    private String jobType2;
}
