package com.elitesland.tw.tw5.api.prd.humanresources.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;

@Data
public class WorkOrderApplyQuery extends TwQueryParam {

    @ApiModelProperty("事由类型")
    private String reasonType;

    @ApiModelProperty("事由号")
    private String reasonName;

    @ApiModelProperty("顾问姓名")
    private String consultantName;

    @ApiModelProperty("申请人")
    private Long applyResId;

    @ApiModelProperty("派工单编号")
    private String applyNo;

    @ApiModelProperty("派工单名称")
    private String applyName;

    @ApiModelProperty("事由号")
    private Long reasonId;

    @ApiModelProperty("服务费(元/人天)")
    private String serviceFee;

    @ApiModelProperty("是否含税")
    private Boolean isTax;

    @ApiModelProperty("预计入场日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate expectedStartDate;

    @ApiModelProperty("预计结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate expectedEndDate;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

}
