package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonEduExperiencePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonEduExperienceVO;

import java.util.List;

public interface PersonEduExperienceService {

    /**
     * 保存资源教育经历信息
     *
     * @param payload
     * @return
     */
    void save(PersonEduExperiencePayload payload);

    /**
     * 查询资源教育经历信息
     *
     * @param personId
     * @return
     */
    List<PersonEduExperienceVO> findAllByPersonId(Long personId);

    /**
     * 批量保存资源教育经历信息
     *
     * @param eduExperienceVOList
     * @param personId
     * @return
     */
    void saveAll(List<PersonEduExperienceVO> eduExperienceVOList, Long personId);

    /**
     * 删除资源教育经历信息
     *
     * @param personId
     * @return
     */
    void deleteAllByPersonId(Long personId);
}
