package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PersonProjectExperienceQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonProjectExperienceVO;

import java.util.List;

public interface PersonProjectExperienceService {

    /**
     * 查询资源项目履历
     *
     * @param personId
     * @return
     */
    List<PersonProjectExperienceVO> findAllByPersonId(Long personId);

    /**
     * 批量保存资源项目履历
     *
     * @param personId
     * @param projectExperienceVOList
     * @return
     */
    void saveAll(List<PersonProjectExperienceVO> projectExperienceVOList, Long personId);

    /**
     * 删除资源项目履历
     *
     * @param personId
     * @return
     */
    void deleteAllByPersonId(Long personId);

    /**
     * 项目履历分页查询
     *
     * @param query
     * @return
     */
    PagingVO<PersonProjectExperienceVO> queryPaging(PersonProjectExperienceQuery query);
}
