package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonRewardPunishPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonRewardPunishVO;

import java.util.List;

public interface PersonRewardPunishService {

    /**
     * 保存奖惩信息
     *
     * @param payload
     * @return
     */
    void save(PersonRewardPunishPayload payload);

    /**
     * 查询奖惩信息
     *
     * @param personId
     * @return
     */
    List<PersonRewardPunishVO> findAllByPersonId(Long personId);

    /**
     * 批量保存资奖惩信息
     *
     * @param personRewardPunishVOList
     * @param personId
     * @return
     */
    void saveAll(List<PersonRewardPunishVO> personRewardPunishVOList, Long personId);

    /**
     * 删除资源奖惩信息
     *
     * @param personId
     * @return
     */
    void deleteAllByPersonId(Long personId);
}
