package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseRegionChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBaseRegionChangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseRegionChangeVO;

import java.util.List;



/**
 * @author : WWW
 * @date : 2023-11-1
 * @desc : base地与社保地变更申请Service
 */
 
public interface PrdBaseRegionChangeService {
    
    /**
     * 新增base地与社保地变更申请数据
     * @param prdBaseRegionChangePayload
     * @return
     */
    PrdBaseRegionChangeVO save(PrdBaseRegionChangePayload prdBaseRegionChangePayload);
    
     /**
     * 根据主键更新
     * @param prdBaseRegionChangePayload
     * @return
     */
    PrdBaseRegionChangeVO update(PrdBaseRegionChangePayload prdBaseRegionChangePayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdBaseRegionChangeVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdBaseRegionChangeQuery
     * @return
     */
    PagingVO<PrdBaseRegionChangeVO> page(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdBaseRegionChangeQuery
      * @return
      */
     List<PrdBaseRegionChangeVO> getList(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery);

     /**
      * 根据条件更新
      * @param prdBaseRegionChangePayload
      * @return
      */
     Long updateByCondition(PrdBaseRegionChangePayload prdBaseRegionChangePayload);

     /**
      * 批量更新
      * @param prdBaseRegionChangePayload
      * @return
      */
     Boolean updateByBatch(List<PrdBaseRegionChangePayload> prdBaseRegionChangePayload);
 }

