package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeIndividAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeIndividAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeIndividAbilityVO;


/**
 * @author : WWW
 * @date : 2023-10-27
 * @desc : 员工-单项能力Service
 */
 
public interface PrdEmployeIndividAbilityService {
    
    /**
     * 新增员工-单项能力数据
     * @param prdEmployeIndividAbilityPayload
     * @return
     */
    PrdEmployeIndividAbilityVO save(PrdEmployeIndividAbilityPayload prdEmployeIndividAbilityPayload);
    
     /**
     * 根据主键更新
     * @param prdEmployeIndividAbilityPayload
     * @return
     */
    PrdEmployeIndividAbilityVO update(PrdEmployeIndividAbilityPayload prdEmployeIndividAbilityPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdEmployeIndividAbilityVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdEmployeIndividAbilityQuery
     * @return
     */
    PagingVO<PrdEmployeIndividAbilityVO> page(PrdEmployeIndividAbilityQuery prdEmployeIndividAbilityQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdEmployeIndividAbilityQuery
      * @return
      */
     List<PrdEmployeIndividAbilityVO> getList(PrdEmployeIndividAbilityQuery prdEmployeIndividAbilityQuery);

     /**
      * 批量新增
      * @param prdEmployeIndividAbilityPayload
      * @return
      */
     Boolean batchSave(List<PrdEmployeIndividAbilityPayload> prdEmployeIndividAbilityPayload);
 }

