package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempPointVO;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板-绩效考核点Service
 */
 
public interface PrdExamTempPointService {
    
    /**
     * 新增绩效考核模板-绩效考核点数据
     * @param prdExamTempPointPayload
     * @return
     */
    PrdExamTempPointVO save(PrdExamTempPointPayload prdExamTempPointPayload);
    
     /**
     * 根据主键更新
     * @param prdExamTempPointPayload
     * @return
     */
    PrdExamTempPointVO update(PrdExamTempPointPayload prdExamTempPointPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdExamTempPointVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdExamTempPointQuery
     * @return
     */
    PagingVO<PrdExamTempPointVO> page(PrdExamTempPointQuery prdExamTempPointQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdExamTempPointQuery
      * @return
      */
     List<PrdExamTempPointVO> getList(PrdExamTempPointQuery prdExamTempPointQuery);
    
        /**
      * 根据条件修改
      * @param prdExamTempPointPayload
      * @return
      */
     Long updateByCondition(PrdExamTempPointPayload prdExamTempPointPayload);

    /**
     * 根据模板id删除
     * @param id
     */
    void delByTempId(Long id);
}

