package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdInternalRecommPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdInternalRecommQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdInternalRecommVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 内部招聘-我的推荐
 *
 * @author zhangxiao
 * @date 2023-12-14
 */
public interface PrdInternalRecommService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdInternalRecommVO}>
     */
    PagingVO<PrdInternalRecommVO> queryPaging(PrdInternalRecommQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdInternalRecommVO}>
     */
    List<PrdInternalRecommVO> queryListDynamic(PrdInternalRecommQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdInternalRecommVO}
     */
    PrdInternalRecommVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdInternalRecommVO}
     */
    PrdInternalRecommVO insert(PrdInternalRecommPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdInternalRecommVO}
     */
    PrdInternalRecommVO update(PrdInternalRecommPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PrdInternalRecommPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据推荐人/被推荐人 更新推荐奖励
     *
     * @return
     */
    Boolean updateFormalReward(PrdInternalRecommPayload prdInternalRecommPayload);


    /**
     * 根据姓名/个人id 查询内推信息
     *
     * @return
     */
    PrdInternalRecommVO getByPersonId(String name, Long personId);

    /**
     * 根据personId修改入职信息
     * @param prdInternalRecommPayload
     * @return
     */
    Boolean updateByPersonId(PrdInternalRecommPayload prdInternalRecommPayload);
}
