package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamRelatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamRelateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamRelateVO;

import javax.servlet.http.HttpServletResponse;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 可查看考核相关人员Service
 */
 
public interface PrdPerformanceExamRelateService {
    
    /**
     * 新增可查看考核相关人员数据
     * @param prdPerformanceExamRelatePayload
     * @return
     */
    PrdPerformanceExamRelateVO save(PrdPerformanceExamRelatePayload prdPerformanceExamRelatePayload);
    
     /**
     * 根据主键更新
     * @param prdPerformanceExamRelatePayload
     * @return
     */
    PrdPerformanceExamRelateVO update(PrdPerformanceExamRelatePayload prdPerformanceExamRelatePayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdPerformanceExamRelateVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdPerformanceExamRelateQuery
     * @return
     */
    PagingVO<PrdPerformanceExamRelateVO> page(PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdPerformanceExamRelateQuery
      * @return
      */
     List<PrdPerformanceExamRelateVO> getList(PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery);
    
        /**
      * 根据条件修改
      * @param prdPerformanceExamRelatePayload
      * @return
      */
     Long updateByCondition(PrdPerformanceExamRelatePayload prdPerformanceExamRelatePayload);
   
}

