package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResDtlVO;

import javax.servlet.http.HttpServletResponse;


 /**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果明细Service
 */
 
public interface PrdPerformanceExamResDtlService {
    
    /**
     * 新增绩效考核结果明细数据
     * @param prdPerformanceExamResDtlPayload
     * @return
     */
    PrdPerformanceExamResDtlVO save(PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload);
    
     /**
     * 根据主键更新
     * @param prdPerformanceExamResDtlPayload
     * @return
     */
    PrdPerformanceExamResDtlVO update(PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdPerformanceExamResDtlVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdPerformanceExamResDtlQuery
     * @return
     */
    PagingVO<PrdPerformanceExamResDtlVO> page(PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdPerformanceExamResDtlQuery
      * @return
      */
     List<PrdPerformanceExamResDtlVO> getList(PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery);
    
        /**
      * 根据条件修改
      * @param prdPerformanceExamResDtlPayload
      * @return
      */
     Long updateByCondition(PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload);
   
}

