package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

@Data
public class EmployeeBlackListVO extends BaseViewModel {

    @ApiModelProperty("员工id")
    private Long employeeId;

    @ApiModelProperty("员工名称")
    private String personName;

    @ApiModelProperty("personId")
    private Long id;

    @ApiModelProperty("Base地")
    private String extString5;

    @ApiModelProperty("资源类型一")
    private String extString6;
    @UdcName(udcName = "org:employee:type", codePropName = "extString6")
    private String extString6Name;

    @ApiModelProperty("资源类型二")
    private String extString9;
    private String extString9Name;

    @ApiModelProperty("资源状态")
    private String resourceStatus;
    @UdcName(udcName = "org:employee:resource", codePropName = "resourceStatus")
    private String resourceStatusName;

    @ApiModelProperty("人才状态")
    private String personStatus;
    @UdcName(udcName = "org:employee:resource", codePropName = "personStatus")
    private String personStatusName;

    @ApiModelProperty("审批状态")
    private ProcInstStatus apprStatus;

    @ApiModelProperty("所属组织")
    private Long orgId;
    @ApiModelProperty("所属组织名称")
    private String orgName;

    @ApiModelProperty("入职日期")
    private LocalDate enrollDate;

    @ApiModelProperty("合同到期日期")
    private LocalDate extDate4;

    @ApiModelProperty("员工编号")
    private String employeeNo;

    public String getApprStatusDesc() {
        if (null == apprStatus) {
            return "";
        }
        return apprStatus.getDesc();
    }
}
