package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;


@SearchBean(
        tables = "employee_depart_apply apply " +
                "left join prd_org_employee emp on emp.id = apply.employee_id ",
        where = "apply.delete_flag = 0",
        autoMapTo = "apply"
)
@Data
public class EmployeeDepartApplyBSVO extends BaseViewModel {

    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag = 0;

    @ApiModelProperty("离职资源")
    private Long employeeId;

    @ApiModelProperty("userId")
    private Long userId;

    @ApiModelProperty("离职资源名称")
    @UdcName(udcName = "USER", codePropName = "userId")
    private String employeeName;

    @ApiModelProperty("入职日期")
    private String enrollDate;

    @ApiModelProperty("BaseBu")
    private Long orgId;

    @ApiModelProperty("BaseBu名称")
    private String orgName;

    @ApiModelProperty("Base地")
    private String extString5;

    @ApiModelProperty("所属公司")
    private Long companyId;

    @ApiModelProperty("所属公司名称")
    private String companyName;

    @ApiModelProperty("直属领导")
    private Long parentId;

    @ApiModelProperty("直属领导")
    private String parentName;

    @ApiModelProperty("备注(离职原因)")
    private String leaveDesc;

    @ApiModelProperty("有无工作交接")
    private String jobHandOverFlag;

    @ApiModelProperty("工作交接人")
    private Long jobHandOverId;

    @ApiModelProperty("工作交接内容")
    private String jobContent;

    @ApiModelProperty("解除劳动合同日期")
    private String contractEndDate;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("邮箱设置")
    private String emailSet;

    @ApiModelProperty("邮件代收人")
    private Long emailReceiverId;

    @ApiModelProperty("最后工作日")
    private String lastJobDate;

    @ApiModelProperty("工号")
    private String employeeNo;

    @ApiModelProperty("离职原因")
    private String hrLeaveDescCode;

    @ApiModelProperty("离职原因说明")
    private String hrReason;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    private String procInstStatusDesc;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("离职办理事项-财务")
    private String leaveFinChk;

    @ApiModelProperty("离职办理事项-人事")
    private String leaveHrChk;

    @ApiModelProperty("离职办理事项-IT")
    private String leaveItChk;

    @ApiModelProperty("离职办理事项-资源")
    private String leaveResChk;

    @ApiModelProperty("离职办理事项-行政")
    private String leaveOffiChk;
}
