package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class WorkOrderApplyVO extends BaseViewModel {

    @ApiModelProperty("派工单名称")
    private String applyName;

    @ApiModelProperty("事由类型")
    private String reasonType;

    @ApiModelProperty("事由ID")
    private Long reasonId;

    @ApiModelProperty("事由号")
    private String reasonName;

    @ApiModelProperty("顾问姓名")
    private String consultantName;

    @ApiModelProperty("复合能力id")
    private Long capasetLevelId;

    @ApiModelProperty("复合能力")
    private String capasetLevelName;

    @ApiModelProperty("预计入场日期")
    private LocalDate expectedStartDate;

    @ApiModelProperty("预计结束日期")
    private LocalDate expectedEndDate;

    @ApiModelProperty("结算类型（人天/任务/月）")
    private String settleType;

    @UdcName(udcName = "org:employee:withdrawSettleMethod", codePropName = "settleType")
    @ApiModelProperty("结算类型（人天/任务/月）")
    private String settleTypeDesc;

    @ApiModelProperty("服务费(元/人天)")
    private String serviceFee;

    @ApiModelProperty("是否含税")
    private Boolean isTax;

    @ApiModelProperty("资源引入情况说明")
    private String situationDescribe;

    @ApiModelProperty("独立顾问个人信息")
    private String personalInfo;

    @ApiModelProperty("被推荐人简历")
    private String resumeCodes;
    private Object resumeDatas;

    @ApiModelProperty("派工单上传")
    private String orderCodes;
    private Object orderDatas;

    @ApiModelProperty("派工单编号")
    private String applyNo;

    @ApiModelProperty("申请人")
    private Long applyResId;
    @UdcName(udcName = "USER", codePropName = "applyResId")
    private String applyResName;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    public String getProcInstStatusDesc() {
        if (null == procInstStatus) {
            return "";
        }
        return procInstStatus.getDesc();
    }
}
