package com.elitesland.tw.tw5.api.prd.inv.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceAttachedPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceAttachedQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceAttachedVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 发票扩展表
 *
 * @author zoey
 * @date 2023-12-06
 */
public interface InvInvoiceAttachedService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link InvInvoiceAttachedVO}>
     */
    PagingVO<InvInvoiceAttachedVO> queryPaging(InvInvoiceAttachedQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link InvInvoiceAttachedVO}>
     */
    List<InvInvoiceAttachedVO> queryListDynamic(InvInvoiceAttachedQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link InvInvoiceAttachedVO}
     */
    InvInvoiceAttachedVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceAttachedVO}
     */
    InvInvoiceAttachedVO insert(InvInvoiceAttachedPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceAttachedVO}
     */
    InvInvoiceAttachedVO update(InvInvoiceAttachedPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(InvInvoiceAttachedPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
