package com.elitesland.tw.tw5.api.prd.inv.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoicePayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 发票主表
 *
 * @author zoey
 * @date 2023-12-05
 */
public interface InvInvoiceService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link InvInvoiceVO}>
     */
    PagingVO<InvInvoiceVO> queryPaging(InvInvoiceQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link InvInvoiceVO}>
     */
    List<InvInvoiceVO> queryListDynamic(InvInvoiceQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link InvInvoiceVO}
     */
    InvInvoiceVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceVO}
     */
    InvInvoiceVO insert(InvInvoicePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceVO}
     */
    InvInvoiceVO update(InvInvoicePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(InvInvoicePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 获取百望发票
     */
    void getInvoicesFromBaiwang(Long userId);

    /**
     * 建立报销单与发票关联关系
     *
     * @param payloads
     */
    void addRelateReimByIds(List<InvInvoicePayload> payloads);

    /**
     * 更新发票报销状态 或 删除报销单与发票关联，并将发票报销状态置为新建
     *
     * @param reimId
     * @param reimStatus 报销状态
     */
    void updateReimStatusByReimId(Long reimId, String reimStatus);


    /**
     * 根据发票号查询抵扣税额/价税合计
     * @param invoiceNos 发票号
     * @return key 发票号 + 发票代码，value 抵扣税额/价税合计
     */
    Map<String, BigDecimal> findDeductTaxDeviceAmountTaxByNoIn(List<String> invoiceNos);

    /**
     * 修改发票核销金额
     * @param newTheAmtMap 新的发票核销金额Map key：发票号-发票代码
     * @param oldTheAmtMap 旧的发票核销金额Map key：发票号-发票代码
     */
    void updateWrittenOffAmtByNo(Map<String, BigDecimal> newTheAmtMap, Map<String, BigDecimal> oldTheAmtMap);

    /**
     * 回滚发票核销金额
     * @param invoiceNoAndCode 需要回滚的发票号-发票代码
     * @param subTheAmt 需要减去的发票核销金额
     */
    void subtractWrittenOffAmt(String invoiceNoAndCode, BigDecimal subTheAmt);

    /**
     * 根据发票号查询发票信息
     * @param invocieNo
     * @return
     */
     List<InvInvoiceVO> queryInvoiceNoByKey(String invocieNo);
}
