package com.elitesland.tw.tw5.api.prd.inv.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceVerDetailPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceVerDetailQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVerDetailVO;

import java.util.List;

/**
 * 发票核销明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
public interface InvInvoiceVerDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link InvInvoiceVerDetailVO}>
     */
    PagingVO<InvInvoiceVerDetailVO> queryPaging(InvInvoiceVerDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link InvInvoiceVerDetailVO}>
     */
    List<InvInvoiceVerDetailVO> queryListDynamic(InvInvoiceVerDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link InvInvoiceVerDetailVO}
     */
    InvInvoiceVerDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceVerDetailVO}
     */
    InvInvoiceVerDetailVO insert(InvInvoiceVerDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceVerDetailVO}
     */
    InvInvoiceVerDetailVO update(InvInvoiceVerDetailPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(InvInvoiceVerDetailPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 批量新增发票核销明细
     *
     * @param invInvoiceVerDetailPayloads 发票核销明细
     */
    void insertAll(List<InvInvoiceVerDetailPayload> invInvoiceVerDetailPayloads);

    /**
     * 根据付款申请单id删除发票核销明细
     *
     * @param paymentApplyId 付款申请单id
     */
    void deleteByPaymentApplyId(Long paymentApplyId);

    /**
     * 根据付款申请单id查询发票核销明细列表
     *
     * @param docType        类型 合同OR协议
     * @param paymentApplyId 付款申请单id
     */
    List<InvInvoiceVerDetailVO> queryListByPaymentApplyId(String docType, Long paymentApplyId);

    /**
     * 根据付款申请单idJDE查询发票核销明细列表
     *
     * @param docType        类型 合同OR协议
     * @param paymentApplyId 付款申请单id
     */
    List<InvInvoiceVerDetailVO> queryListByJdePaymentApplyId(String docType, Long paymentApplyId);

}
