package com.elitesland.tw.tw5.api.prd.inv.service;

import com.elitesland.tw.tw5.api.prd.inv.payload.InvItemCatPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvItemCatQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemCatVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 发票商品分类对象
 *
 * @author zoey
 * @date 2023-07-31
 */
public interface InvItemCatService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link InvItemCatVO}>
     */
    PagingVO<InvItemCatVO> queryPaging(InvItemCatQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link InvItemCatVO}>
     */
    List<InvItemCatVO> queryListDynamic(InvItemCatQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link InvItemCatVO}
     */
    InvItemCatVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link InvItemCatVO}
     */
    InvItemCatVO insert(InvItemCatPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link InvItemCatVO}
     */
    InvItemCatVO update(InvItemCatPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(InvItemCatPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
