package com.elitesland.tw.tw5.api.prd.inv.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;


/**
 * 发票核销明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Getter
@Setter
public class InvInvoiceVerDetailVO extends BaseViewModel implements Serializable {
    /**
     * 付款申请单ID
     */
    @ApiModelProperty("付款申请单ID")
    private Long paymentApplyId;
    /**
     * 发票号
     */
    @ApiModelProperty("发票号")
    private String invoiceNo;
    /**
     * 本次核销金额
     */
    @ApiModelProperty("本次核销金额")
    private BigDecimal theAmt;
    /**
     * 发票金额
     */
    @ApiModelProperty("发票金额")
    private BigDecimal invoiceAmt;
    /**
     * 已核销金额
     */
    @ApiModelProperty("已核销金额")
    private BigDecimal writtenOffAmt;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private String rate;
    /**
     * 发票类型
     */
    @ApiModelProperty("发票类型")
    private String invoiceType;
    @ApiModelProperty("发票类型Desc")
    @UdcName(udcName = "INV:INPUT_INV_TYPE", codePropName = "invoiceType")
    private String invoiceTypeDesc;
    /**
     * 搜索类型
     */
    @ApiModelProperty("搜索类型")
    private String searchType;
    /**
     * 发票查验状态
     */
    @ApiModelProperty("发票查验状态")
    private String inspection;
    @ApiModelProperty("发票查验状态Desc")
    @UdcName(udcName = "INV:INV_INSPECTION_STATUS", codePropName = "inspection")
    private String inspectionDesc;
    /**
     * 发票日期
     */
    @ApiModelProperty("发票日期")
    private LocalDate invoiceDate;
    /**
     * 发票代码
     */
    @ApiModelProperty("发票代码")
    private String invoiceCode;
    /**
     * 本人OR其他 true为本人，false为其他
     */
    @ApiModelProperty("本人OR其他 true为本人，false为其他")
    private Boolean selfFlag;
    /**
     * 2023-12-21新增关联采购明细>
     */
    @ApiModelProperty("关联采购明细Id")
    private Long purConOrAgreementDetailId;
    @ApiModelProperty("关联产品Id")
    private Long relatedProductId;
    @ApiModelProperty("关联产品Name")
    private String relatedProductName;
    /**
     * 2024-01-26新增发票抵扣税额字段
     */
    @ApiModelProperty("关联发票抵扣税额")
    private BigDecimal deductTax = BigDecimal.ZERO;

    /**
     * 附件url
     */
    @ApiModelProperty("附件")
    private String imgContent;

    /**
     * 发票凭证
     */
    @ApiModelProperty("jde发票凭证")
    private String invoiceVoucher;

    /** jde单据公司 */
    @ApiModelProperty("jde单据公司")
    private String jdeCompany;
    /** jde单据号  */
    @ApiModelProperty("jde单据号 ")
    private String jdeDocumentNo;
    /** jde单据类型 */
    @ApiModelProperty("jde单据类型")
    private String jdeDocumentType;
    /** jde付款项 */
    @ApiModelProperty("jde付款项")
    private String jdePaymentItem;
    /** jde发票凭证失败原因 */
    @ApiModelProperty("jde发票凭证失败原因")
    private String jdeInvoiceFailReason;

    /** 税额 */
    @ApiModelProperty("税额")
    private BigDecimal taxAmount;

}
