package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
 * 远程办公申请明细
 *
 * @author wangly
 * @date 2024-06-12
 */
@Data
public class AbnormalWorkApplyDetailPayload extends TwCommonPayload  implements Serializable {
    /** 远程办公申请ID */
    @ApiModelProperty("远程办公申请ID")
    private Long applyId;
    /** 月份 */
    @ApiModelProperty("月份")
    private String workMonth;
    /** 远程办公日期 */
    @ApiModelProperty("远程办公日期")
    private LocalDate workDate;
    /** 远程办公天数 */
    @ApiModelProperty("远程办公天数")
    private BigDecimal workDays;
    /** 0.5天区分上午下午 AM上午 PM下午 */
    @ApiModelProperty("0.5天区分上午下午 AM上午 PM下午")
    private String workInterval;
    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private String procInstStatus;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

}
