package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


@Data
public class RewardLeaveApplyPayload extends TwCommonPayload {

    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /**
     * 事由号
     */
    @ApiModelProperty("事由号")
    private Long reasonId;
    /**
     * 事由名称
     */
    @ApiModelProperty("事由名称")
    private String reasonName;
    /**
     * 预计开始日期
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    /**
     * 预计上线日期
     */
    @ApiModelProperty("预计上线日期")
    private LocalDate planOnlineDate;
    /**
     * 预算总人天
     */
    @ApiModelProperty("预算总人天")
    private BigDecimal totalDays;
    /**
     * 原始规划当量
     */
    @ApiModelProperty("原始规划当量")
    private BigDecimal originalPlanEqva;
    /**
     * 变更当量
     */
    @ApiModelProperty("变更当量")
    private BigDecimal planEqvaChange;
    /**
     * 累计投入当量占比
     */
    @ApiModelProperty("累计投入当量占比")
    private BigDecimal totalEqvaProportion;
    /**
     * 报告完工百分比
     */
    @ApiModelProperty("报告完工百分比")
    private BigDecimal reprotCompPercent;
    /**
     * 项目风险等级
     */
    @ApiModelProperty("项目风险等级")
    private String riskLevel;
    /**
     * 有效期
     */
    @ApiModelProperty("有效期")
    private LocalDate expirationDate;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    private List<RewardLeaveApplyDetailPayload> detailPayloadList;

}
