package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
* 工时用-任务表
*
* @author duwh
* @date 2022-12-10
*/
@Data
public class TaskPayload extends TwCommonPayload  {
    /** 4.0任务主键 */
    private Long taskIdV4;
    /** 任务编号 */
    private String taskNo;
    /** 任务名称 */
    private String taskName;
    /**
     * 任务状态 - T_TASK.TASK_STATUS
     *
     * UDC:TSK:TASK_STATUS
     *
     * 新建	CREATE
     * 派发中 DISPATCH
     * 处理中 IN PROCESS
     * 暂挂	PENDING
     * 验收中 VALIDATING
     * 完成	FINISHED
     * 关闭	CLOSED
     */
    private String taskStatus;
    /** 发包资源id */
    private Long disterUserId;
    /** 费用承担bu_id */
    private Long expenseBuId;
    /** 接收资源bu_id */
    private Long receiverBuId;
    /** 接收资源id */
    private Long receiverUserId;
    /** 接收资源 v4 userId id */
    //private Long receiverResId;
    /** 事由类型 01 项目 02 售前 03 bu */
    private String reasonType;
    /** 事由id */
    private Long reasonId;
    /** 事由id v4 */
    private Long reasonIdv4;
    /** 计划开始日期 */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate planStartDate;
    /** 计划结束日期 */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate planEndDate;
    /** 验收方式 */
    private String acceptMethod;
    /** 计价方式 */
    private String pricingMethod;
    /** 派发人天数 */
    private BigDecimal days;
    /** bu结算价 */
    private BigDecimal buSettlePrice;
    /** 派发当量系数 */
    private BigDecimal eqvaRatio;
    /** 总当量数 */
    private BigDecimal eqvaQty;
    /** 当量结算单价 */
    private BigDecimal settlePrice;
    /** 已结算当量数 */
    private BigDecimal settledEqva;
    /** 已结算人天数 */
    private BigDecimal settledDays;
    /** 已结算金额 */
    private BigDecimal settledAmt;
    /** 任务包类型 */
    private String taskPackageType;
    /** 任务来源类型 */
    private String taskSourceType;
    /** 任务包关闭时间 */
    private LocalDateTime closedTime;
    /** 定时任务自动结算当量标记 */
    private Integer autoSettleFlag;
    /** 发包日期 */
    private LocalDate distDate;
    /** 追加当量;记录任务包当量变更流程累计追加的当量 */
    private BigDecimal addEqva;
    /** 原始发包当量；用于记录第一次任务包派发流程审批通过时的任务包当量 */
    private BigDecimal baseTaskEqva;
    /** 拓展1 */
    private String ext1;
    /** 拓展2 */
    private String ext2;
    /** 拓展3 */
    private String ext3;
    /** 拓展4 */
    private String ext4;
    /** 拓展5 */
    private String ext5;
    /** 事由名称冗余 */
    private String reasonName;
    /**
     * 工时填报剩余可用当量
     */
    private BigDecimal effectiveEqva;
    /**
     * 任务包自动申请所在周的周一日期（工作日期）
     */
    private LocalDate workDate;
}
