package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;

import java.time.LocalDate;
import java.util.Collection;
import java.util.List;

/**
* 工时-资源活动
*
* @author duh
* @date 2022-12-21
*/
@Data
public class ResActivityQuery extends TwQueryParam{
        /** 4.0活动主键 */
    /** 精确 */
    @Query
    private Long activityIdV4;
        /** 活动编号 */
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String actNo;
        /** 活动名称 */
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String actName;
        /** 活动状态 */
    /** 精确 */
    @Query
    private String actStatus;
        /** 活动资源id */
    /** 精确 */
    @Query
    private Long actResId;
        /** 项目活动 */
    /** 精确 */
    @Query
    private String projAct;
        /** 预计开始日期 */
    /** 精确 */
    @Query
    private LocalDate planStartDate;
        /** 预计结束日期 */
    /** 精确 */
    @Query
    private LocalDate planEndDate;
        /** 任务id 4.0 */
    /** 精确 */
    @Query
    private Long taskId;
    /** 任务id 4.0 */
    /** 精确 */
    @Query(type = Query.Type.IN)
    private Collection taskIds;
        /** 项目活动id */
    /** 精确 */
    @Query
    private Long projActivityId;
        /** 资源活动父id */
    /** 精确 */
    @Query
    private Long resActivityPid;
}
