package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Getter
@Setter
public class RewardLeaveApplyQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 事由类型 精确
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /**
     * 事由号 精确
     */
    @ApiModelProperty("事由号")
    private Long reasonId;
    /**
     * 事由名称 精确
     */
    @ApiModelProperty("事由名称")
    private String reasonName;
    /**
     * 预计开始日期 精确
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /**
     * 预计结束日期 精确
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    /**
     * 预计上线日期 精确
     */
    @ApiModelProperty("预计上线日期")
    private LocalDate planOnlineDate;
    /**
     * 预算总人天 精确
     */
    @ApiModelProperty("预算总人天")
    private BigDecimal totalDays;
    /**
     * 原始规划当量 精确
     */
    @ApiModelProperty("原始规划当量")
    private BigDecimal originalPlanEqva;
    /**
     * 报告完工百分比 精确
     */
    @ApiModelProperty("报告完工百分比")
    private BigDecimal reprotCompPercent;
    /**
     * 项目风险等级 精确
     */
    @ApiModelProperty("项目风险等级")
    private String riskLevel;
    /**
     * 有效期 精确
     */
    @ApiModelProperty("有效期")
    private LocalDate expirationDate;
    /**
     * 流程实例ID 精确
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态 精确
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 审批时间 精确
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 变更当量 精确
     */
    @ApiModelProperty("变更当量")
    private BigDecimal planEqvaChange;
    /**
     * 累计投入当量占比 精确
     */
    @ApiModelProperty("累计投入当量占比")
    private BigDecimal totalEqvaProportion;
}

