package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 自购电脑申请
 *
 * @author lemon
 * @date 2023-09-19
 */
@Getter
@Setter
public class TDeviceApplyQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 申请单号 精确 */
    @ApiModelProperty("申请单号")
    private String applyNo;
    /** 申请状态 精确 */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    /** 申请日期 精确 */
    @ApiModelProperty("申请日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDate;
    /** 申请人资源ID 精确 */
    @ApiModelProperty("申请人资源ID")
    private Long applyResId;
    /** 每月补贴金额 精确 */
    @ApiModelProperty("每月补贴金额")
    private BigDecimal monthlyAmt;
    /** 票据号 精确 */
    @ApiModelProperty("票据号")
    private String billNo;
    /** 品牌型号及颜色 精确 */
    @ApiModelProperty("品牌型号及颜色")
    private String deviceDesc;
    /** 内存 精确 */
    @ApiModelProperty("内存")
    private String memSize;
    /** 硬盘 精确 */
    @ApiModelProperty("硬盘")
    private String hdSize;
    /** 购置价格 精确 */
    @ApiModelProperty("购置价格")
    private BigDecimal devicePrice;
    /** 购置日期 精确 */
    @ApiModelProperty("购置日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate buyDate;
    /** 补贴起始月份 精确 */
    @ApiModelProperty("补贴起始月份")
    private Integer startPeriodId;
    /** 申请理由 精确 */
    @ApiModelProperty("申请理由")
    private String applyDesc;
    /** 申请人BU_ID 精确 */
    @ApiModelProperty("申请人BU_ID")
    private Long resBuId;
    /** 流程实例ID 精确 */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 精确 */
    @ApiModelProperty("流程审批状态")
    private String procInstStatus;
    /** 提交时间 精确 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 精确 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}
