package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 服务器申请
 *
 * @author lemon
 * @date 2023-09-23
 */
@Getter
@Setter
public class TServerApplyQuery extends TwQueryParam implements Serializable{
    /**  精确 */
    @ApiModelProperty("")
    private Long id;
    /** 申请人 精确 */
    @ApiModelProperty("申请人")
    private Long applyResId;
    /** 申请时间 精确 */
    @ApiModelProperty("申请时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDateStart;
    /** 申请时间 精确 */
    @ApiModelProperty("申请时间结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDateEnd;
    /** 申请bu 精确 */
    @ApiModelProperty("申请bu")
    private Long applyBuId;
    /** 使用人姓名 精确 */
    @ApiModelProperty("使用人姓名")
    private Long userResId;
    /** 使用bu 精确 */
    @ApiModelProperty("使用bu")
    private Long userBuId;
    /** 用途 精确 */
    @ApiModelProperty("用途")
    private String purpose;
    /** 服务器类型 精确 */
    @ApiModelProperty("服务器类型")
    private String type;
    /** 服务器品牌 精确 */
    @ApiModelProperty("服务器品牌")
    private String brand;
    /** 使用范围 精确 */
    @ApiModelProperty("使用范围")
    private String useScope;
    /** 预计费用 精确 */
    @ApiModelProperty("预计费用")
    private BigDecimal expectAmt;
    /** 费用承担bu 精确 */
    @ApiModelProperty("费用承担bu")
    private Long expenseBuId;
    /** CPU 精确 */
    @ApiModelProperty("CPU")
    private String cpu;
    /** 内存 精确 */
    @ApiModelProperty("内存")
    private String memory;
    /** 硬盘 精确 */
    @ApiModelProperty("硬盘")
    private String hardDisk;
    /** 系统类型 精确 */
    @ApiModelProperty("系统类型")
    private String sysType;
    /** 生效日期 精确 */
    @ApiModelProperty("生效日期")
    private LocalDate effectiveDate;
    /** 使用日期开始 精确 */
    @ApiModelProperty("使用日期开始")
    private LocalDate useDateStart;
    /** 使用日期结束 精确 */
    @ApiModelProperty("使用日期结束")
    private LocalDate useDateEnd;
    /** 采购合同id 精确 */
    @ApiModelProperty("采购合同id")
    private Long purchaseConId;
    /** 申请编号 精确 */
    @ApiModelProperty("申请编号")
    private String applyNo;
    /** 申请状态 精确 */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    /** 服务器名称 精确 */
    @ApiModelProperty("服务器名称")
    private String serverName;
    /** 流程实例ID 精确 */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 精确 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 精确 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 精确 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}
