package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
* 工时用-任务表
*
* @author duwh
* @date 2022-12-10
*/
@Data
public class TaskQuery extends TwQueryParam{

    /**
     * 关键字 模糊匹配taskNo,taskName
     */
    @Query(blurry = "taskNo,taskName")
    private String keyword;
    /** 精确 */
    @Query
    private Long taskIdV4;
    /** v4taskId IN查询 */
    @Query(type = Query.Type.IN, propName = "taskIdV4")
    private Collection<Long> taskIdV4List;
    /** 任务编号 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskNo;
    /** 任务名称 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskName;
    /**
     * 任务状态 - T_TASK.TASK_STATUS
     *
     * UDC:TSK:TASK_STATUS
     *
     * 新建	CREATE
     * 派发中 DISPATCH
     * 处理中 IN PROCESS
     * 暂挂	PENDING
     * 验收中 VALIDATING
     * 完成	FINISHED
     * 关闭	CLOSED
     */
    @Query
    private String taskStatus;
    /** 任务状态 多个匹配  in */
    @Query(type = Query.Type.IN, propName = "taskStatus")
    private List<String> taskStatusList;
    /** 发包人 精确 */
    @Query
    private Long disterUserId;
    /** 费用承担bu 精确 */
    @Query
    private Long expenseBuId;
    /** 精确 */
    @Query
    private Long receiverBuId;
    /** 接包人 精确 */
    @Query
    private Long receiverUserId;
    /** 精确 */
    @Query
    private String reasonType;
    @Query(type = Query.Type.NOT_EQUAL, propName = "reasonType")
    private String notEqualReasonType;
    /** 精确 */
    @Query
    private Long reasonId;
    /** 4.0事由id */
    @Query
    private Long reasonIdv4;
    /** 精确 */
    @Query
    private String acceptMethod;
    /** 精确 */
    @Query
    private String pricingMethod;
    /** 精确 */
    @Query
    private String taskPackageType;
    /** 精确 */
    @Query
    private String taskSourceType;
    /** 精确 */
    @Query
    private Integer autoSettleFlag;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String reasonName;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> planStartDate;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> planEndDate;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<BigDecimal> eqvaQty;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<BigDecimal> settledEqva;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<BigDecimal> settledDays;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<BigDecimal> settledAmt;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<LocalDateTime> closedTime;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> distDate;

    /**
     * 已填工时当量
     */
    private BigDecimal usedEqva;

    /**
     * 工时填报剩余可用当量
     */
    @Query(type = Query.Type.GREATER_THAN)
    private BigDecimal effectiveEqva;
}
