package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.List;
import java.util.Set;

/**
* 双周计划
*
* @author duwh
* @date 2022-12-21
*/
@Data
public class TimesheetBiweeklyQuery extends TwQueryParam{
    /** 标题 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String title;
    /** 双周计划类型 精确 */
    @Query
    private String tsbType;
    /** 双周计划Buid 精确 */
    @Query
    private Long tsbBuId;
    /** 发送对象 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String receiveUserIds;
    /** 是否已读 0 未读  1已读 */
    @Query
    private Integer isRead;
    /** 查询开始日期*/
    @Query
    private LocalDate startDate;
    /** 查询结束日期*/
    @Query
    private LocalDate endDate;

    /** 所在月的第一天 */
    @Query
    private String monthDate;
    /** 所在年周 */
    @Query
    private Integer yearWeek;
    /** 所在年周 */
    @Query(type = Query.Type.IN, propName = "yearWeek")
    private List<Integer> yearWeekIn;
    /** 拓展1 精确 */
    @Query
    private String ext1;
    /** 拓展2 精确 */
    @Query
    private String ext2;
    /** 拓展3 精确 */
    @Query
    private String ext3;
    /** 本周开始日期 BETWEEN */
    @Query(type = Query.Type.EQUAL, propName = "startWeekDate")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startWeekDateQuery;
    /** 本周开始日期 BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> startWeekDate;
    /** 提交人 精确 */
    @Query
    private Long tsUserId;
    /** 读取人 精确 */
    @Query
    private Long readUserId;

    /**
     * 提交人 or  审批人
     */
    private Long userId;
    /**
     * 提交人 前端筛选
     */
    @Query(type = Query.Type.EQUAL, propName = "tsUserId")
    private Long createUserId;

    /**
     * 是否需要权限判断
     */
    private Boolean isPermission = true;

    /**
     * 用户id
     */
    private Set<Long> userIdList;

    /**
     * 部门及子部门id
     */
    private Set<Long> orgIdList;
    /**
     * 部门类型 BM-平台支持类BU  BS-销售BU  BD-事业部BU	BY-研发事业部BU
     */
    @Query
    private String organizationType;

}
