package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 工时补贴标准配置表
 *
 * @author duwh
 * @date 2024-07-13
 */
@Getter
@Setter
public class TimesheetSubsidySettingQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 事由类型 PROJ_CONTRACT合同项目 PROJ_OPPO售前商机项目  PROJ_BU部门BU项目 精确 */
    @ApiModelProperty("事由类型 PROJ_CONTRACT合同项目 PROJ_OPPO售前商机项目  PROJ_BU部门BU项目")
    private String reasonType;
    /** 可选 事由id 精确 */
    @ApiModelProperty("可选 事由id")
    private Long reasonId;
    /** 可选 事由名称 精确 */
    @ApiModelProperty("可选 事由名称")
    private String reasonName;
    /** 是否工作日 WORK工作日 HOLIDAY节假日 精确 */
    @ApiModelProperty("是否工作日 WORK工作日 HOLIDAY节假日")
    private String workDateType;
    /** 周末现场是否考虑补助 Y考虑 N不考虑 精确 */
    @ApiModelProperty("周末现场是否考虑补助 Y考虑 N不考虑")
    private String holidaySubsidyType;
    /** 可选补助类型 */
    @ApiModelProperty("可选补助类型 显示名称")
    private String subsidySelectTypeName;
    @ApiModelProperty("可选补助类型 编码")
    private String subsidySelectTypeCode;
    /** 可选补助类型 是否默认值 Y赋值默认值 其他不管 精确 */
    @ApiModelProperty("可选补助类型 是否默认值 Y赋值默认值 其他不管")
    private String subsidySelectDefaultFlag;
    /** 可填写工时 数值格式 多个英文逗号隔开 精确 */
    @ApiModelProperty("可填写工时 数值格式 多个英文逗号隔开")
    private String workHourSelect;
    /** 拓展 可填写工时对应udc 精确 */
    @ApiModelProperty("拓展 可填写工时对应udc")
    private String workHourSelectUdcKey;
    /** 工时计算调整 实际参与计算补助的值 精确 */
    @ApiModelProperty("工时计算调整 实际参与计算补助的值")
    private BigDecimal workHourCal;
    /** 补贴标准 NO没有补助 TRAVEL出差补贴 ON_SITE现场补贴 精确 */
    @ApiModelProperty("补贴标准 NO没有补助 TRAVEL出差补贴 ON_SITE现场补贴")
    private String subsidyStdType;
    /** 项目补助规则-周末可填写补助  工作日 无视  节假日根据项目中的规则判断 */
    @ApiModelProperty("项目补助规则-周末可填写补助 工作日 无视  节假日根据项目中的规则判断  Y周末现场有补助")
    private String projectSubsidyRole;
    /** 拓展1 精确 */
    @ApiModelProperty("拓展1")
    private String ext1;
    /** 拓展2 精确 */
    @ApiModelProperty("拓展2")
    private String ext2;
    /** 拓展3 精确 */
    @ApiModelProperty("拓展3")
    private String ext3;
    /** 拓展4 精确 */
    @ApiModelProperty("拓展4")
    private String ext4;
    /** 拓展5 精确 */
    @ApiModelProperty("拓展5")
    private String ext5;
}
