package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.PrdOrgEmployeeConfigPayload;
import com.elitesland.tw.tw5.api.prd.my.query.PrdOrgEmployeeConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdOrgEmployeeConfigVO;

import java.util.List;

/**
 * 员工-个人配置
 *
 * @author wangly
 * @date 2024-03-27
 */
public interface PrdOrgEmployeeConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdOrgEmployeeConfigVO}>
     */
    PagingVO<PrdOrgEmployeeConfigVO> queryPaging(PrdOrgEmployeeConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdOrgEmployeeConfigVO}>
     */
    List<PrdOrgEmployeeConfigVO> queryListDynamic(PrdOrgEmployeeConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdOrgEmployeeConfigVO}
     */
    PrdOrgEmployeeConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdOrgEmployeeConfigVO}
     */
    PrdOrgEmployeeConfigVO insert(PrdOrgEmployeeConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdOrgEmployeeConfigVO}
     */
    PrdOrgEmployeeConfigVO update(PrdOrgEmployeeConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PrdOrgEmployeeConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
