package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.ProjectPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjectQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectAndTaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 工时用-项目表
 *
 * @author duwh
 * @date 2022-12-09
 */
public interface ProjectService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ProjectVO}>
     */
    PagingVO<ProjectVO> paging(ProjectQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ProjectVO}>
     */
    List<ProjectVO> queryList(ProjectQuery query);

    /**
     * 工作计划 下拉选择用
     *
     * @param query 查询
     * @return {@link List}<{@link ProjectAndTaskVO}>
     */
    List<ProjectAndTaskVO> queryListForSelect(ProjectQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ProjectVO}
     */
    ProjectVO queryByKey(Long key);

    ProjectVO queryByProjIdV4(Long projIdV4);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ProjectVO}
     */
    ProjectVO insert(ProjectPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ProjectVO}
     */
    ProjectVO update(ProjectPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * Excel导出数据
     *
     * @param all      待导出的数据
     * @param response /
     * @throws IOException /
     */
    void download(List<ProjectVO> all, HttpServletResponse response) throws IOException;

    Map<Long, Long> getV4AndV5ProjectIds();
}
