package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRulePayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceRuleQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.*;

import java.time.LocalDate;
import java.util.List;

public interface TAttendanceRuleService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TAttendanceRuleVO}>
     */
    PagingVO<TAttendanceRuleVO> queryPaging(TAttendanceRuleQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TAttendanceRuleVO}>
     */
    List<TAttendanceRuleVO> queryListDynamic(TAttendanceRuleQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TAttendanceRuleVO}
     */
    TAttendanceRuleVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TAttendanceRuleVO}
     */
    TAttendanceRuleVO insert(TAttendanceRulePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TAttendanceRuleVO}
     */
    TAttendanceRuleVO update(TAttendanceRulePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TAttendanceRulePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 获取资源的打卡规则
     *
     * @param resId 资源ID
     * @return 资源的打卡规则集合
     */
    List<TAttendanceRuleVO> getAttendanceRule();

    /**
     * 获取资源的打卡规则
     *
     * @param resId 资源ID
     * @return 资源的打卡规则集合
     */
    List<MobAttendanceRuleVO> getAttendanceRule(long resId);


    List<MobAttendanceRuleVO> isAttendance(List<MobAttendanceRuleVO> list);


    int resAttendanceInfo(MobAttendanceVO payload);


    /**
     * 资源打卡记录
     *
     * @param resId               资源ID
     * @param attendanceDateStart 打卡开始时间
     * @param attendanceDateEnd   打卡结束时间
     * @return 打卡记录
     */
    List<MobAttendanceLogVO> resAttendanceLog(long resId, LocalDate attendanceDateStart, LocalDate attendanceDateEnd);

    /**
     * 异常更新说明
     *
     * @param info 异常更新说明
     * @return 更新结果
     */
    int resAttendanceReason(TAttendanceNormalVO info);

    /**
     * 获取今日打卡数据
     *
     * @param resId
     * @param attendanceDate
     * @return
     */
    MobAttendanceResVO getResAttendanceInfo(Long resId, LocalDate attendanceDate);


    /**
     * 同步打卡数据方法--只更新当天数据
     *
     * @return
     */
    void updateAttendanceInformation(LocalDate date);


}
