package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TBusinessRulesPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusinessRulesQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusinessRulesVO;

import java.util.List;

public interface TBusinessRulesService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TBusinessRulesVO}>
     */
    PagingVO<TBusinessRulesVO> queryPaging(TBusinessRulesQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TBusinessRulesVO}>
     */
    List<TBusinessRulesVO> queryListDynamic(TBusinessRulesQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TBusinessRulesVO}
     */
    TBusinessRulesVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TBusinessRulesVO}
     */
    TBusinessRulesVO insert(TBusinessRulesPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TBusinessRulesVO}
     */
    TBusinessRulesVO update(TBusinessRulesPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TBusinessRulesPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
