package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TMoneyTransferPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TMoneyTransferQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TMoneyTransferVO;

import java.util.List;

/**
 * 资金划款
 *
 * @author wangluyu
 * @date 2024-02-27
 */
public interface TMoneyTransferService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TMoneyTransferVO}>
     */
    PagingVO<TMoneyTransferVO> queryPaging(TMoneyTransferQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TMoneyTransferVO}>
     */
    List<TMoneyTransferVO> queryListDynamic(TMoneyTransferQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TMoneyTransferVO}
     */
    TMoneyTransferVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TMoneyTransferVO}
     */
    TMoneyTransferVO insert(TMoneyTransferPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TMoneyTransferVO}
     */
    TMoneyTransferVO update(TMoneyTransferPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TMoneyTransferPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
