package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetBiweeklyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetBiweeklyVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetReportFormVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;

/**
 * 双周计划
 *
 * @author duwh
 * @date 2022-12-21
 */
public interface TimesheetBiweeklyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TimesheetBiweeklyVO}>
     */
    PagingVO<TimesheetBiweeklyVO> paging(TimesheetBiweeklyQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TimesheetBiweeklyVO}>
     */
    PagingVO<TimesheetBiweeklyVO> pagingNew(TimesheetBiweeklyQuery query);

    /**
     * 报表分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TimesheetBiweeklyVO}>
     */
    PagingVO<TimesheetReportFormVO> pagingReportForms(TimesheetBiweeklyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TimesheetBiweeklyVO}>
     */
    List<TimesheetBiweeklyVO> queryList(TimesheetBiweeklyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TimesheetBiweeklyVO}
     */
    TimesheetBiweeklyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TimesheetBiweeklyVO}
     */
    TimesheetBiweeklyVO insert(TimesheetBiweeklyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TimesheetBiweeklyVO}
     */
    TimesheetBiweeklyVO update(TimesheetBiweeklyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * Excel导出数据
     *
     * @param all      待导出的数据
     * @param response /
     * @throws IOException /
     */
    void download(List<TimesheetBiweeklyVO> all, HttpServletResponse response) throws IOException;

    /**
     * 查询用户周报
     * @param userId
     * @param date
     * @return
     */
    TimesheetBiweeklyVO queryByUserIdAndDate(Long userId, LocalDate date);


}
