package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationPayload;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface UserVacationService {

    /**
     * 假期管理新增
     *
     * @param payload
     * @return
     */
    void save(UserVacationPayload payload);

    /**
     * 假期管理分页查询
     *
     * @param query
     * @return
     */
    PagingVO<UserVacationVO> page(UserVacationQuery query);

    /**
     * 假期管理列表查询
     *
     * @param query
     * @return
     */
    List<UserVacationVO> list(UserVacationQuery query);

    /**
     * 根据id查询假期管理详情
     *
     * @param id
     * @return
     */
    UserVacationVO queryById(Long id);

    /**
     * 假期管理批量删除
     *
     * @param ids
     * @return
     */
    void delete(Long[] ids);

    /**
     * 假期管理批量修改有效期
     *
     * @param payloadList
     * @return
     */
    void updateExpirationBatch(List<UserVacationPayload> payloadList);

    /**
     * 获取当前用户可用假期
     *
     * @param userId
     * @return
     */
    List<UserVacationVO> getAvailableVacation(Long userId, Long vacationId);

    /**
     * 删除用户假期
     *
     * @param userId
     * @return
     */
    void deleteAllByUserId(Long userId);

    /**
     * 计算可用假期天数
     *
     * @param userVacationList
     * @return
     */
    void calculateAvailableDay(List<UserVacationVO> userVacationList);

    /**
     * 导入模板下载
     *
     * @param response 响应
     */
    void tmpDownload(HttpServletResponse response);

    /**
     * 假期管理批量导入
     */
    String importBatch(MultipartFile file, Boolean force);

    /**
     * 奖励假保存
     */
    void saveRewardLeave(UserVacationPayload payload);
}
